const int ecgPin = A3;  // AD8232 output connected to A3
int ecgValue = 0;        // Variable to store the ECG signal
int smoothedValue = 0;   // Variable to store the smoothed signal

const int numReadings = 4;  // Number of readings for moving average
int readings[numReadings];   // Array to store readings
int readIndex = 0;           // Index of the current reading
int total = 0;               // Total of the readings
int average = 0;             // Average of the readings

void setup() {
  // Start serial communication at 9600 baud rate
  Serial.begin(9600);
  
  // Initialize all readings to 0
  for (int i = 0; i < numReadings; i++) {
    readings[i] = 0;
  }
}

void loop() {
  // Read the ECG signal from the AD8232
  ecgValue = analogRead(ecgPin);

  // Subtract the last reading from the total
  total -= readings[readIndex];
  
  // Add the new reading to the total
  readings[readIndex] = ecgValue;
  total += ecgValue;
  
  // Move to the next index, and wrap around if necessary
  readIndex = (readIndex + 1) % numReadings;
  
  // Calculate the average of the readings
  average = total / numReadings;

  // Print the smoothed value to the serial monitor (it will show up on the Serial Plotter)
  Serial.println(average);

  // Add a small delay to make the plot smoother (optional)
  delay(10);  // Adjust delay for smoother data depending on sampling rate
}
